#pragma once


#include <ctime>
#include <sstream>
#include <iomanip>
#include <string>

void Particles()
{
    
  ImVec2 screen_size = ImVec2(g_GlWidth, g_GlHeight);
    static ImVec2 partile_pos[100];
    static ImVec2 partile_target_pos[100];
    static float partile_speed[100];
    static float partile_radius[100];


    for (int i = 1; i < 50; i++)
    {
        if (partile_pos[i].x == 0 || partile_pos[i].y == 0)
        {
            partile_pos[i].x = rand() % (int)screen_size.x + 1;
            partile_pos[i].y = 15.f;
            partile_speed[i] = 1 + rand() % 25;
            partile_radius[i] = rand() % 4;

            partile_target_pos[i].x = rand() % (int)screen_size.x;
            partile_target_pos[i].y = screen_size.y * 2;
        }

        partile_pos[i] = ImLerp(partile_pos[i], partile_target_pos[i], ImGui::GetIO().DeltaTime * (partile_speed[i] / 60));

        if (partile_pos[i].y > screen_size.y)
        {
            partile_pos[i].x = 0;
            partile_pos[i].y = 0;
        }

        ImGui::GetWindowDrawList()->AddCircleFilled(partile_pos[i], partile_radius[i], ImColor(255,255,255, 255/2));
    }

}


class ExpireDate {
    public:
    ExpireDate() {
        std::time_t now = std::time(nullptr);
        expirationTime = std::chrono::system_clock::from_time_t(now);
    }
    void setExpirationDate(int day, int month, int year) {
        std::tm tm_struct = {};
        tm_struct.tm_mday = day;
        tm_struct.tm_mon = month - 1;
        tm_struct.tm_year = year - 1900;
        std::time_t expirationTime_t = std::mktime(&tm_struct);
        expirationTime = std::chrono::system_clock::from_time_t(expirationTime_t);
    }
    bool isExpired() {
        std::chrono::system_clock::time_point now = std::chrono::system_clock::now();
        return now >= expirationTime;
    }
    private:
    std::chrono::system_clock::time_point expirationTime;
};
